
#define BX_REG_BOARD_REQASSERT_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x0008))
#define BX_REG_SYS_RELAY_REG        ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x0068))

/* Size of one FAUST image in bytes.
   I added one dummy byte to get a QW-aligned address 
   for the two following version bytes (needed in BestXFaustCheck()) */
#define BX_FAUST_IMAGE_SIZE (2992071+1)


/* To the CPU, only one MB (out of the 16MB) of HW flash
   is accessible without changing Cocos page pointer */
#define BX_FAUST_IMAGEPAGE_START        0x00C00000
#define BX_FAUST_IMAGEPAGE_END          0x00CFFFFF


/* Protocol checker (Faust only)
   We got 8 (*3) 32bit registers resulting in a maximum of 256 possible rules */ 
#define BX_REG_PROT_ERR_MASK_F        ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2080))
#define BX_REG_FIRST_ERR_F            ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x20A0))   
#define BX_REG_ACCUM_ERR_REG_F        ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x20C0))
#define BX_REG_OBS_CTRL_STATUS_REG_F  ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x20E0))
#define BX_REG_SEM_10_PL_REG_F        ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x20E4))
#define BX_REG_SEM_11_PL_REG_F        ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x20E8))

/* Extended Config Space memory access for Faust */
#define BX_REG_CNF_MEM_DATA_F    ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x55A0))
#define BX_REG_CNF_MEM_ADDR_F    ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x55A4))

/***********************************************************************
*** Following code generated by Perl-Script
*** addrmap.pl 
*** from map.txt
************************************************************************/
#define BX_REG_CHIP_REV_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x0000))
#define BX_REG_EX_CLK_SWITCH_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x0020))
#define BX_REG_EX_CLK_SWITCH_STAT_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x0024))
#define BX_REG_AN_CLK_SWITCH_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x0028))
#define BX_REG_AN_CLK_SWITCH_STAT_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x002C))
#define BX_REG_TR_CLK_SWITCH_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x0030))
#define BX_REG_TR_CLK_SWITCH_STAT_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x0034))
#define BX_REG_SYS_CLK_MODE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x0038))
#define BX_REG_PLL_RESYNC_STRB ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x003C))
#define BX_REG_PCIX_MEN_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x0040))
#define BX_REG_PCI_BW_CNTRL_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x0044))
#define BX_REG_INTR_STATUS_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x0050))
#define BX_REG_SYS_INTR_MASK_STAT_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x0054))
#define BX_REG_SYS_INTR_STAT_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x0058))
#define BX_REG_RES_LOCK_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x0060))
#define BX_REG_SYS_CTRL_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x0064))
#define BX_REG_SYS_RESETPATT_F ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x0070))
#define BX_REG_SYS_RESETIMG_F ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x0074))
#define BX_REG_SYS_RELOAD_EN ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x0078))
#define BX_REG_SYS_STAT_MONITOR ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x007C))
#define BX_REG_MEPH_BASE_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x1000))
#define BX_REG_DEF_ROM_BASE_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x1008))
#define BX_REG_DEF_ROM_SIZE_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x100C))
#define BX_REG_LED0_ROM_BASE_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x1010))
#define BX_REG_LED0_SIZE_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x1014))
#define BX_REG_DEF_ROM_DTACK_DEL_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x1018))
#define BX_REG_LED0_DTACK_DEL_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x101C))
#define BX_REG_LED0_DTACK_DEL_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x101C))
#define BX_REG_BERR_DEL_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x1020))
#define BX_REG_DBI_STATUS_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x1040))
#define BX_REG_DBI_CMD_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x1044))
#define BX_REG_DEFLOAD_RESTART_STRB ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x1048))
#define BX_REG_DEFLOAD_PROG_START_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x104C))
#define BX_REG_DEFLOAD_CURR_PROG_CNTR_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x1050))
#define BX_REG_DEFLOAD_MAX_INSTR_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x1054))
#define BX_REG_DEFLOAD_WAIT_CLOCKS_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x1058))
#define BX_REG_AN_EN_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x2000))
#define BX_REG_AN_EN_SREG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x2004))
#define BX_REG_AN_EN_STATUS ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x2008))
#define BX_REG_AN_EN_FORCE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x200C))
#define BX_REG_PROT_ERR_MASK_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2080))
#define BX_REG_FIRST_ERR_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2088))
#define BX_REG_ACCUM_ERR_REG_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2090))
#define BX_REG_ERR_REG_SH_STRB_M ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x2098))
#define BX_REG_ERR_REG_RST_STRB_M ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x20A0))
#define BX_REG_ERR_SM_RST_STRB_M ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x20A8))
#define BX_REG_SYNCED_STATUS_REG_M ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x20B0))
#define BX_REG_STAT_OBS_ERR_REG_M ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x20B8))
#define BX_REG_SEM_10_CNTR_M ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x20C0))
#define BX_REG_SEM_10_PL_REG_M ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x20C8))
#define BX_REG_SEM_11_CNTR_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x20D0))
#define BX_REG_SEM_11_PL_REG_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x20D8))


/* Mephisto Bus pattern terms */
#define BX_REG_BLK0_BUS_PATTERN_0_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2100))
#define BX_REG_BLK0_BUS_PATTERN_1_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2104))
#define BX_REG_BLK0_BUS_PATTERN_2_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2108))
#define BX_REG_BLK0_BUS_PATTERN_3_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x210C))
#define BX_REG_BLK0_MASK_BUS_PATTERN_0_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2110))
#define BX_REG_BLK0_MASK_BUS_PATTERN_1_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2114))
#define BX_REG_BLK0_MASK_BUS_PATTERN_2_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2118))
#define BX_REG_BLK0_MASK_BUS_PATTERN_3_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x211C))
#define BX_REG_BLK0_BUS_OE_REG_M ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x2120))
#define BX_REG_BLK1_MASK_BUS_PATTERN_0_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2150))
#define BX_REG_BLK1_MASK_BUS_PATTERN_1_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2154))
#define BX_REG_BLK1_MASK_BUS_PATTERN_2_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2158))
#define BX_REG_BLK1_MASK_BUS_PATTERN_3_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x215C))
#define BX_REG_BLK1_BUS_PATTERN_0_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2140))
#define BX_REG_BLK1_BUS_PATTERN_1_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2144))
#define BX_REG_BLK1_BUS_PATTERN_2_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2148))
#define BX_REG_BLK1_BUS_PATTERN_3_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x214C))
#define BX_REG_BLK1_BUS_OE_REG_M ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x2160))
#define BX_REG_BLK0_COND_PATTERN_0_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2180))
#define BX_REG_BLK0_COND_PATTERN_1_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2184))
#define BX_REG_BLK0_COND_PATTERN_2_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2188))
#define BX_REG_BLK0_COND_PATTERN_3_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x218C))
#define BX_REG_BLK0_MASK_COND_PATTERN_0_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2190))
#define BX_REG_BLK0_MASK_COND_PATTERN_1_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2194))
#define BX_REG_BLK0_MASK_COND_PATTERN_2_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2198))
#define BX_REG_BLK0_MASK_COND_PATTERN_3_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x219C))
#define BX_REG_BLK0_COND_OE_REG_M ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x21A0))
#define BX_REG_BLK1_COND_PATTERN_0_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x21C0))
#define BX_REG_BLK1_COND_PATTERN_1_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x21C4))
#define BX_REG_BLK1_COND_PATTERN_2_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x21C8))
#define BX_REG_BLK1_COND_PATTERN_3_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x21CC))
#define BX_REG_BLK1_MASK_COND_PATTERN_0_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x21D0))
#define BX_REG_BLK1_MASK_COND_PATTERN_1_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x21D4))
#define BX_REG_BLK1_MASK_COND_PATTERN_2_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x21D8))
#define BX_REG_BLK1_MASK_COND_PATTERN_3_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x21DC))
#define BX_REG_BLK1_COND_OE_REG_M ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x21E0))


/* Faust Bus pattern terms */
#define BX_REG_BLK0_BUS_PATTERN_0_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2600))
#define BX_REG_BLK0_BUS_PATTERN_1_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2604))
#define BX_REG_BLK0_BUS_PATTERN_2_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2608))
#define BX_REG_BLK0_BUS_PATTERN_3_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x260c))
#define BX_REG_BLK0_MASK_BUS_PATTERN_0_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2610))
#define BX_REG_BLK0_MASK_BUS_PATTERN_1_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2614))
#define BX_REG_BLK0_MASK_BUS_PATTERN_2_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2618))
#define BX_REG_BLK0_MASK_BUS_PATTERN_3_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x261c))
#define BX_REG_BLK0_BUS_OE_REG_F ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x2620))
#define BX_REG_BLK1_BUS_PATTERN_0_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2640))
#define BX_REG_BLK1_BUS_PATTERN_1_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2644))
#define BX_REG_BLK1_BUS_PATTERN_2_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2648))
#define BX_REG_BLK1_BUS_PATTERN_3_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x264c))
#define BX_REG_BLK1_MASK_BUS_PATTERN_0_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2650))
#define BX_REG_BLK1_MASK_BUS_PATTERN_1_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2654))
#define BX_REG_BLK1_MASK_BUS_PATTERN_2_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2658))
#define BX_REG_BLK1_MASK_BUS_PATTERN_3_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x265c))
#define BX_REG_BLK1_BUS_OE_REG_F ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x2660))
#define BX_REG_BLK0_COND_PATTERN_0_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2680))
#define BX_REG_BLK0_COND_PATTERN_1_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2684))
#define BX_REG_BLK0_COND_PATTERN_2_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2688))
#define BX_REG_BLK0_COND_PATTERN_3_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x268c))
#define BX_REG_BLK0_MASK_COND_PATTERN_0_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2690))
#define BX_REG_BLK0_MASK_COND_PATTERN_1_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2694))
#define BX_REG_BLK0_MASK_COND_PATTERN_2_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2698))
#define BX_REG_BLK0_MASK_COND_PATTERN_3_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x269c))
#define BX_REG_BLK0_COND_OE_REG_F ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x26A0))
#define BX_REG_BLK1_COND_PATTERN_0_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x26C0))
#define BX_REG_BLK1_COND_PATTERN_1_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x26C4))
#define BX_REG_BLK1_COND_PATTERN_2_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x26C8))
#define BX_REG_BLK1_COND_PATTERN_3_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x26Cc))
#define BX_REG_BLK1_MASK_COND_PATTERN_0_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x26D0))
#define BX_REG_BLK1_MASK_COND_PATTERN_1_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x26D4))
#define BX_REG_BLK1_MASK_COND_PATTERN_2_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x26D8))
#define BX_REG_BLK1_MASK_COND_PATTERN_3_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x26Dc))
#define BX_REG_BLK1_COND_OE_REG_F ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x26E0))

/* Error pattern term */
#define BX_REG_ERR_PATTERN ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x2200))
#define BX_REG_ERR_MASK_PATTERN ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x2210))
#define BX_REG_ERR_OE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x2220))

/* Transient pattern term */
#define BX_REG_TRAN_PAT_MASK_0 ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2240))
#define BX_REG_TRAN_PAT_MASK_1 ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2244))
#define BX_REG_TRAN_PAT_MASK_2 ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2248))
#define BX_REG_TRAN_OE_REG_M ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x2250))
#define BX_REG_TRAN_OE_REG_F ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x2250))

/* Mephisto Observer patterns */
#define BX_REG_BLK0_OBS_PATTERN_0_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2300))
#define BX_REG_BLK0_OBS_PATTERN_1_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2304))
#define BX_REG_BLK0_OBS_PATTERN_2_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2308))
#define BX_REG_BLK0_OBS_PATTERN_3_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x230C))
#define BX_REG_BLK0_MASK_OBS_PATTERN_0_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2310))
#define BX_REG_BLK0_MASK_OBS_PATTERN_1_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2314))
#define BX_REG_BLK0_MASK_OBS_PATTERN_2_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2318))
#define BX_REG_BLK0_MASK_OBS_PATTERN_3_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x231C))
#define BX_REG_BLK0_OBS_OE_REG_M ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x2320))
#define BX_REG_BLK1_OBS_PATTERN_0_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2340))
#define BX_REG_BLK1_OBS_PATTERN_1_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2344))
#define BX_REG_BLK1_OBS_PATTERN_2_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2348))
#define BX_REG_BLK1_OBS_PATTERN_3_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x234C))
#define BX_REG_BLK1_MASK_OBS_PATTERN_0_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2350))
#define BX_REG_BLK1_MASK_OBS_PATTERN_1_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2354))
#define BX_REG_BLK1_MASK_OBS_PATTERN_2_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2358))
#define BX_REG_BLK1_MASK_OBS_PATTERN_3_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x235C))
#define BX_REG_BLK1_OBS_OE_REG_M ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x2360))
#define BX_REG_BLK2_OBS_PATTERN_0_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2380))
#define BX_REG_BLK2_OBS_PATTERN_1_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2384))
#define BX_REG_BLK2_OBS_PATTERN_2_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2388))
#define BX_REG_BLK2_OBS_PATTERN_3_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x238C))
#define BX_REG_BLK2_MASK_OBS_PATTERN_0_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2390))
#define BX_REG_BLK2_MASK_OBS_PATTERN_1_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2390))
#define BX_REG_BLK2_MASK_OBS_PATTERN_2_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2398))
#define BX_REG_BLK2_MASK_OBS_PATTERN_3_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x239C))
#define BX_REG_BLK2_OBS_OE_REG_M ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x23A0))
#define BX_REG_BLK3_OBS_PATTERN_0_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x23C0))
#define BX_REG_BLK3_OBS_PATTERN_1_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x23C4))
#define BX_REG_BLK3_OBS_PATTERN_2_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x23C8))
#define BX_REG_BLK3_OBS_PATTERN_3_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x23CC))
#define BX_REG_BLK3_MASK_OBS_PATTERN_0_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x23D0))
#define BX_REG_BLK3_MASK_OBS_PATTERN_1_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x23D4))
#define BX_REG_BLK3_MASK_OBS_PATTERN_2_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x23D8))
#define BX_REG_BLK3_MASK_OBS_PATTERN_3_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x23DC))
#define BX_REG_BLK3_OBS_OE_REG_M ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x23E0))

/* Faust Observer patterns */
#define BX_REG_BLK0_OBS_PATTERN_0_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2400))
#define BX_REG_BLK0_OBS_PATTERN_1_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2404))
#define BX_REG_BLK0_OBS_PATTERN_2_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2408))
#define BX_REG_BLK0_OBS_PATTERN_3_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x240C))
#define BX_REG_BLK0_MASK_OBS_PATTERN_0_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2410))
#define BX_REG_BLK0_MASK_OBS_PATTERN_1_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2414))
#define BX_REG_BLK0_MASK_OBS_PATTERN_2_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2418))
#define BX_REG_BLK0_MASK_OBS_PATTERN_3_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x241C))
#define BX_REG_BLK0_OBS_OE_REG_F ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x2420))
#define BX_REG_BLK1_OBS_PATTERN_0_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2440))
#define BX_REG_BLK1_OBS_PATTERN_1_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2444))
#define BX_REG_BLK1_OBS_PATTERN_2_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2448))
#define BX_REG_BLK1_OBS_PATTERN_3_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x244C))
#define BX_REG_BLK1_MASK_OBS_PATTERN_0_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2450))
#define BX_REG_BLK1_MASK_OBS_PATTERN_1_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2454))
#define BX_REG_BLK1_MASK_OBS_PATTERN_2_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2458))
#define BX_REG_BLK1_MASK_OBS_PATTERN_3_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x245C))
#define BX_REG_BLK1_OBS_OE_REG_F ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x2460))
#define BX_REG_BLK2_OBS_PATTERN_0_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2480))
#define BX_REG_BLK2_OBS_PATTERN_1_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2484))
#define BX_REG_BLK2_OBS_PATTERN_2_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2488))
#define BX_REG_BLK2_OBS_PATTERN_3_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x248C))
#define BX_REG_BLK2_MASK_OBS_PATTERN_0_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2490))
#define BX_REG_BLK2_MASK_OBS_PATTERN_1_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2490))
#define BX_REG_BLK2_MASK_OBS_PATTERN_2_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x2498))
#define BX_REG_BLK2_MASK_OBS_PATTERN_3_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x249C))
#define BX_REG_BLK2_OBS_OE_REG_F ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x24A0))
#define BX_REG_BLK3_OBS_PATTERN_0_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x24C0))
#define BX_REG_BLK3_OBS_PATTERN_1_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x24C4))
#define BX_REG_BLK3_OBS_PATTERN_2_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x24C8))
#define BX_REG_BLK3_OBS_PATTERN_3_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x24CC))
#define BX_REG_BLK3_MASK_OBS_PATTERN_0_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x24D0))
#define BX_REG_BLK3_MASK_OBS_PATTERN_1_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x24D4))
#define BX_REG_BLK3_MASK_OBS_PATTERN_2_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x24D8))
#define BX_REG_BLK3_MASK_OBS_PATTERN_3_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x24DC))
#define BX_REG_BLK3_OBS_OE_REG_F ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x24E0))


#define BX_REG_BLK0_RAM_CNTR ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x3400))
#define BX_REG_BLK0_PERF_DBI_REG_0 ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3404))
#define BX_REG_BLK0_PERF_DBI_REG_1 ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3408))
#define BX_REG_BLK0_PERF_DBI_REG_2 ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x340C))
#define BX_REG_BLK0_PERF_DBI_REG_3 ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3410))
#define BX_REG_BLK0_PERF_DBI_REG_4 ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3414))
#define BX_REG_BLK0_PERF_DBI_REG_5 ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3418))
#define BX_REG_BLK0_PERF_DBI_REG_6 ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x341C))
#define BX_REG_BLK0_PERF_PL_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3420))
#define BX_REG_BLK0_PERF_CNTR_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3424))
#define BX_REG_BLK0_BYTE_CNTR_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3428))
#define BX_REG_BLK0_BC_EN_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x342C))
#define BX_REG_BLK0_INCR_32_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3430))
#define BX_REG_BLK0_OV_STATUS_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x3434))
#define BX_REG_BLK1_RAM_CNTR ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x3480))
#define BX_REG_BLK1_PERF_DBI_REG_0 ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3484))
#define BX_REG_BLK1_PERF_DBI_REG_1 ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3488))
#define BX_REG_BLK1_PERF_DBI_REG_2 ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x348C))
#define BX_REG_BLK1_PERF_DBI_REG_3 ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3490))
#define BX_REG_BLK1_PERF_DBI_REG_4 ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3494))
#define BX_REG_BLK1_PERF_DBI_REG_5 ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3498))
#define BX_REG_BLK1_PERF_DBI_REG_6 ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x349C))
#define BX_REG_BLK1_PERF_PL_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x34A0))
#define BX_REG_BLK1_PERF_CNTR_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x34A4))
#define BX_REG_BLK1_BYTE_CNTR_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x34A8))
#define BX_REG_BLK1_BC_EN_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x34AC))
#define BX_REG_BLK1_INCR_32_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x34B0))
#define BX_REG_BLK1_OV_STATUS_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x34B4))
#define BX_REG_BLK2_RAM_CNTR ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x3500))
#define BX_REG_BLK2_PERF_DBI_REG_0 ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3504))
#define BX_REG_BLK2_PERF_DBI_REG_1 ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3508))
#define BX_REG_BLK2_PERF_DBI_REG_2 ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x350C))
#define BX_REG_BLK2_PERF_DBI_REG_3 ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3510))
#define BX_REG_BLK2_PERF_DBI_REG_4 ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3514))
#define BX_REG_BLK2_PERF_DBI_REG_5 ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3518))
#define BX_REG_BLK2_PERF_DBI_REG_6 ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x351C))
#define BX_REG_BLK2_PERF_PL_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3520))
#define BX_REG_BLK2_PERF_CNTR_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3524))
#define BX_REG_BLK2_BYTE_CNTR_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3528))
#define BX_REG_BLK2_BC_EN_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x352C))
#define BX_REG_BLK2_INCR_32_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3530))
#define BX_REG_BLK2_OV_STATUS_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x3534))
#define BX_REG_BLK3_RAM_CNTR ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x3580))
#define BX_REG_BLK3_PERF_DBI_REG_0 ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3584))
#define BX_REG_BLK3_PERF_DBI_REG_1 ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3588))
#define BX_REG_BLK3_PERF_DBI_REG_2 ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x358C))
#define BX_REG_BLK3_PERF_DBI_REG_3 ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3590))
#define BX_REG_BLK3_PERF_DBI_REG_4 ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3594))
#define BX_REG_BLK3_PERF_DBI_REG_5 ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3598))
#define BX_REG_BLK3_PERF_DBI_REG_6 ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x359C))
#define BX_REG_BLK3_PERF_PL_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x35A0))
#define BX_REG_BLK3_PERF_CNTR_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x35A4))
#define BX_REG_BLK3_BYTE_CNTR_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x35A8))
#define BX_REG_BLK3_BC_EN_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x35AC))
#define BX_REG_BLK3_INCR_32_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x35B0))
#define BX_REG_BLK3_OV_STATUS_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x35B4))
#define BX_REG_PERF_RAM_PL_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x35C4))
#define BX_REG_PERF_RAM_CNTR_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x35C8))
#define BX_REG_PERF_RAM_ADDR_PL_STRB ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x35CC))
#define BX_REG_PERF_RST_EN_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x35D0))
#define BX_REG_PERF_LOC_SW_RST ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x35D4))
#define BX_REG_PERF_RST_DTCT_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x35D8))
#define BX_REG_PERF_SH_STRB_CNTR ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x35DC))
#define BX_REG_PERF_RUN_CNTR_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x35E0))
#define BX_REG_PERF_CNTR_OV_READ ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x35E4))
#define BX_REG_LOCAL_SW_RESET ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x3900))
#define BX_REG_FREQ_PL_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3980))
#define BX_REG_FREQ_DECR_PL ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x3988))
#define BX_REG_FREQ_DECR_SH_CE ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x398C))
#define BX_REG_FREQ_SH_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3990))
#define BX_REG_PCIFREQ_INCR32_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x399C))
#define BX_REG_PLLFREQ_INCR32_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x39A0))
#define BX_REG_FREQ_RDY_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x39A4))
#define BX_REG_R_A_CNTR_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3B04))
#define BX_REG_M_W_CNTR_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3B08))
#define BX_REG_TRC_TRIG_CNTR_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3B0C))
#define BX_REG_TRC_TRIG_PL_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3B10))
#define BX_REG_TR_STATUS_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3B14))
#define BX_REG_TR_LOCAL_SM_RSTN ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3B20))
#define BX_REG_TR_LOCAL_REG_RSTN ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3B24))
#define BX_REG_TRIG_SEQ_MEM ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x3C00))
#define BX_REG_TRIG_DBI_REG_0 ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3C04))
#define BX_REG_TRIG_DBI_REG_1 ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3C08))
#define BX_REG_TRIG_DBI_REG_2 ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3C0C))
#define BX_REG_TRIG_DBI_REG_3 ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3C10))
#define BX_REG_TRIG_DBI_REG_4 ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3C14))
#define BX_REG_TRIG_DBI_REG_5 ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3C18))
#define BX_REG_TRIG_DBI_REG_6 ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3C1C))
#define BX_REG_TRIG_PL_A_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3C28))
#define BX_REG_TRIG_CNTR_A_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3C2c))
#define BX_REG_TRIG_PL_B_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3C20))
#define BX_REG_TRIG_CNTR_B_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x3C24))
#define BX_REG_TRIG_RAM_PL_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x3C44))
#define BX_REG_TRIG_RAM_CNTR_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x3C48))
#define BX_REG_TRIG_RAM_ADDR_PL_STRB ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x3C4C))
#define BX_REG_TRIG_RST_EN_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x3C50))
#define BX_REG_TRIG_LOC_SW_RST ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x3C54))
#define BX_REG_TRIG_RST_DTCT_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x3C58))
#define BX_REG_MBLOCK_DATA_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x4000))
#define BX_REG_MBLOCK_MIN_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4004))
#define BX_REG_MBLOCK_MAX_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4006))
#define BX_REG_MBLOCK_CTR ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4008))
#define BX_REG_MBLOCK_SKIP_ADDR_0 ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x400C))
#define BX_REG_MBLOCK_SKIP_ADDR_1 ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4010))
#define BX_REG_MBLOCK_SKIP_ADDR_2 ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4014))
#define BX_REG_MBLOCK_SKIP_ADDR_3 ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4018))
#define BX_REG_MBLOCK_SKIP_ADDR_4 ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x401C))
#define BX_REG_MBLOCK_SKIP_ADDR_5 ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4020))
#define BX_REG_MBLOCK_SKIP_ADDR_6 ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4024))
#define BX_REG_MBLOCK_SKIP_ADDR_7 ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4028))
#define BX_REG_MBLOCK_ERR_SRCE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x402C))
#define BX_REG_MBLOCK_TRIG_SRCE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4030))
#define BX_REG_MBLOCK_INT_SRCE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4034))
#define BX_REG_MBLOCK_CTR_LOOP_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4040))
#define BX_REG_MBLOCK_REP_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x4080))
#define BX_REG_MBLOCK_REP_CTR ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x4084))
#define BX_REG_MBEHAV_DATA_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x4100))
#define BX_REG_MBEHAV_MIN_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4104))
#define BX_REG_MBEHAV_MAX_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4106))
#define BX_REG_MBEHAV_CTR ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4108))
#define BX_REG_MBEHAV_CTR1 ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x410C))
#define BX_REG_MBEHAV_CTR2 ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4110))
#define BX_REG_MBEHAV_CTR3 ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4114))
#define BX_REG_MBEHAV_CTR4 ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4118))
#define BX_REG_MBEHAV_CTR5 ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x411C))
#define BX_REG_MBEHAV_CTR6 ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4120))
#define BX_REG_MBEHAV_CTR7 ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4124))
#define BX_REG_MBEHAV_CTR8 ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4128))
#define BX_REG_MBEHAV_CTR9 ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x412C))
#define BX_REG_MBEHAV_CTR0_LOOP_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4140))
#define BX_REG_MBEHAV_CTR1_LOOP_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4144))
#define BX_REG_MBEHAV_CTR2_LOOP_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4148))
#define BX_REG_MBEHAV_CTR3_LOOP_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x414C))
#define BX_REG_MBEHAV_CTR4_LOOP_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4150))
#define BX_REG_MBEHAV_CTR5_LOOP_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4154))
#define BX_REG_MBEHAV_CTR6_LOOP_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4158))
#define BX_REG_MBEHAV_CTR7_LOOP_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x415C))
#define BX_REG_MBEHAV_CTR8_LOOP_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4160))
#define BX_REG_MBEHAV_CTR9_LOOP_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4164))
#define BX_REG_MBEH_ERR_SRCE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4170))
#define BX_REG_MBEH_TRIG_SRCE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4174))
#define BX_REG_MBEH_INT_SRCE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4178))
#define BX_REG_CBEHAV_DATA_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x4200))
#define BX_REG_CBEHAV_MIN_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4204))
#define BX_REG_CBEHAV_MAX_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4206))
#define BX_REG_CBEHAV_CTR ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4208))
#define BX_REG_CBEHAV_CTR1 ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x420C))
#define BX_REG_CBEHAV_CTR2 ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4210))
#define BX_REG_CBEHAV_CTR3 ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4214))
#define BX_REG_CBEHAV_CTR4 ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4218))
#define BX_REG_CBEHAV_CTR5 ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x421C))
#define BX_REG_CBEHAV_CTR6 ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4220))
#define BX_REG_CBEHAV_CTR7 ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4224))
#define BX_REG_CBEHAV_CTR8 ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4228))
#define BX_REG_CBEH_ERR_SRCE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4230))
#define BX_REG_CBEH_TRIG_SRCE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4234))
#define BX_REG_CBEH_INT_SRCE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4238))
#define BX_REG_CBEHAV_CTR0_LOOP_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4240))
#define BX_REG_CBEHAV_CTR1_LOOP_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4244))
#define BX_REG_CBEHAV_CTR2_LOOP_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4248))
#define BX_REG_CBEHAV_CTR3_LOOP_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x424C))
#define BX_REG_CBEHAV_CTR4_LOOP_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4250))
#define BX_REG_CBEHAV_CTR5_LOOP_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4254))
#define BX_REG_CBEHAV_CTR6_LOOP_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4258))
#define BX_REG_CBEHAV_CTR7_LOOP_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x425C))
#define BX_REG_CBEHAV_CTR8_LOOP_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4260))
#define BX_REG_CBEHAV_RSVD_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4270))
#define BX_REG_XACT_MODE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4300))
#define BX_REG_NUM_M_XACTS_MIN_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4304))
#define BX_REG_NUM_M_XACTS_MAX_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4308))
#define BX_REG_NUM_C_XACTS_MIN_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x430C))
#define BX_REG_NUM_C_XACTS_MAX_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4310))
#define BX_REG_XACT_WAIT_CNT_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x4314))
#define BX_REG_MXACT_CNT_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x431C))
#define BX_REG_CXACT_CNT_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4320))
#define BX_REG_EX_RUN_CTRL_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4400))
#define BX_REG_EX_RUN_CTRL_STATE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4404))
#define BX_REG_EX_RUN_CTRL_FORCE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4408))
#define BX_REG_EX_RUN_CTRL_SYNC_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x440C))
#define BX_REG_EX_RUN_CTRL_RESET ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4410))
#define BX_REG_MRUN_STOP_STATUS_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4414))
#define BX_REG_SM_CLEAR_STATE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4418))
#define BX_REG_SM_CLEAR_STATE_CLR_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x441C))
#define BX_REG_PCI_X_COMPLIANCE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4420))
#define BX_REG_C_EMPTY_CHECK_CTR ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4422))
#define BX_REG_C_Q_EMPTY_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4424))
#define BX_REG_MSM_INFO_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5200))
#define BX_REG_MBURST_LEN_CTR ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5204))
#define BX_REG_MADB_CTR ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5208))
#define BX_REG_MLAT_CTR ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x520C))
#define BX_REG_MSM_ABORT_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5210))
#define BX_REG_MSM_STAT_MON ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5214))
#define BX_REG_RTBEHAV_DATA_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x4500))
#define BX_REG_RTBEHAV_MIN_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4504))
#define BX_REG_RTBEHAV_MAX_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4506))
#define BX_REG_RTBEHAV_CTR ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4508))
#define BX_REG_RTBEHAV_CTR1 ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x450C))
#define BX_REG_RTBEHAV_CTR2 ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4510))
#define BX_REG_RTBEHAV_CTR3 ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4514))
#define BX_REG_RTBEHAV_CTR4 ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4518))
#define BX_REG_RTBEH_ERR_SRCE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4520))
#define BX_REG_RTBEH_TRIG_SRCE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4524))
#define BX_REG_RTBEH_INT_SRCE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4528))
#define BX_REG_RTBEHAV_CTR0_LOOP_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4540))
#define BX_REG_RTBEHAV_CTR1_LOOP_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4544))
#define BX_REG_RTBEHAV_CTR2_LOOP_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4548))
#define BX_REG_RTBEHAV_CTR3_LOOP_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x454C))
#define BX_REG_RTBEHAV_CTR4_LOOP_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4550))
#define BX_REG_TBEHAV_DATA_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x4600))
#define BX_REG_TBEHAV_MIN_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4604))
#define BX_REG_TBEHAV_MAX_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4606))
#define BX_REG_TBEHAV_CTR ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4608))
#define BX_REG_TBEHAV_CTR1 ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x460C))
#define BX_REG_TBEHAV_CTR2 ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4610))
#define BX_REG_TBEHAV_CTR3 ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4614))
#define BX_REG_TBEHAV_CTR4 ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4618))
#define BX_REG_TBEH_ERR_SRCE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4620))
#define BX_REG_TBEH_TRIG_SRCE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4624))
#define BX_REG_TBEH_INT_SRCE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4628))
#define BX_REG_TBEHAV_CTR0_LOOP_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4640))
#define BX_REG_TBEHAV_CTR1_LOOP_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4644))
#define BX_REG_TBEHAV_CTR2_LOOP_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4648))
#define BX_REG_TBEHAV_CTR3_LOOP_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x464C))
#define BX_REG_TBEHAV_CTR4_LOOP_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x4650))
#define BX_REG_DEC_EN_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5000))
#define BX_REG_DEC_EN_SREG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5004))
#define BX_REG_DEC_EN_STATUS_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5008))
#define BX_REG_DEC_EN_FORCE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x500C))
#define BX_REG_STD0_CTRL_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5010))
#define BX_REG_STD0_RES_BASE_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5014))
#define BX_REG_STD0_RES_SIZE_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5018))
#define BX_REG_STD1_CTRL_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5020))
#define BX_REG_STD1_RES_BASE_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5024))
#define BX_REG_STD1_RES_SIZE_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5028))
#define BX_REG_STD2_CTRL_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5030))
#define BX_REG_STD2_RES_BASE_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5034))
#define BX_REG_STD2_RES_SIZE_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5038))
#define BX_REG_STD3_CTRL_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5040))
#define BX_REG_STD3_RES_BASE_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5044))
#define BX_REG_STD3_RES_SIZE_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5048))
#define BX_REG_STD4_CTRL_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5050))
#define BX_REG_STD4_RES_BASE_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5054))
#define BX_REG_STD4_RES_SIZE_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5058))
#define BX_REG_STD5_CTRL_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5060))
#define BX_REG_STD5_RES_BASE_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5064))
#define BX_REG_STD5_RES_SIZE_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5068))
#define BX_REG_EXPROM_CTRL_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5070))
#define BX_REG_EXPROM_RES_BASE_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5074))
#define BX_REG_EXPROM_RES_SIZE_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5078))
#define BX_REG_GEN_DEC_PROP_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5080))
#define BX_REG_TSPLIT0_ADDRMASK_LO_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5090))
#define BX_REG_TSPLIT0_ADDRMASK_HI_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5094))
#define BX_REG_TSPLIT0_ADDRVAL_LO_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5098))
#define BX_REG_TSPLIT0_ADDRVAL_HI_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x509C))
#define BX_REG_TSPLIT0_CMD_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x50A0))
#define BX_REG_TSPLIT0_DEC_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x50A4))
#define BX_REG_TSPLIT0_QUEUE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x50A8))
#define BX_REG_TSPLIT1_ADDRMASK_LO_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x50B0))
#define BX_REG_TSPLIT1_ADDRMASK_HI_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x50B4))
#define BX_REG_TSPLIT1_ADDRVAL_LO_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x50B8))
#define BX_REG_TSPLIT1_ADDRVAL_HI_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x50BC))
#define BX_REG_TSPLIT1_CMD_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x50C0))
#define BX_REG_TSPLIT1_DEC_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x50C4))
#define BX_REG_TSPLIT1_QUEUE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x50C8))
#define BX_REG_TSPLIT2_ADDRMASK_LO_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x50D0))
#define BX_REG_TSPLIT2_ADDRMASK_HI_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x50D4))
#define BX_REG_TSPLIT2_ADDRVAL_LO_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x50D8))
#define BX_REG_TSPLIT2_ADDRVAL_HI_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x50DC))
#define BX_REG_TSPLIT2_CMD_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x50E0))
#define BX_REG_TSPLIT2_DEC_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x50E4))
#define BX_REG_TSPLIT2_QUEUE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x50E8))
#define BX_REG_TSPLIT3_ADDRMASK_LO_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x50F0))
#define BX_REG_TSPLIT3_ADDRMASK_HI_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x50F4))
#define BX_REG_TSPLIT3_ADDRVAL_LO_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x50F8))
#define BX_REG_TSPLIT3_ADDRVAL_HI_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x50FC))
#define BX_REG_TSPLIT3_CMD_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5100))
#define BX_REG_TSPLIT3_DEC_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5104))
#define BX_REG_TSPLIT3_QUEUE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5108))
#define BX_REG_RTMAP_MEM_ADDR_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5110))
#define BX_REG_RTMAP_MEM_DATA_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5114))
#define BX_REG_DEC_ERR_SRCE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5120))
#define BX_REG_DEC_TRIG_SRCE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5124))
#define BX_REG_DEC_INT_SRCE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5128))
#define BX_REG_DEC_SPLIT_ERR_MSG_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5130))
#define BX_REG_FORCE_RETRY_BIT_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5134))
#define BX_REG_FORCE_RETRY_SYNC_BIT_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5138))
#define BX_REG_TRIG_EN_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5300))
#define BX_REG_INTA_CLK_CNT_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5304))
#define BX_REG_INTB_CLK_CNT_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5308))
#define BX_REG_INTC_CLK_CNT_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x530C))
#define BX_REG_INTD_CLK_CNT_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5310))
#define BX_REG_PH_CNT_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5314))
#define BX_REG_PH_EN_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5318))
#define BX_REG_ERR_EN_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x531C))
#define BX_REG_INT_EN_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5320))
#define BX_REG_INT_ASSERT_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5324))
#define BX_REG_ERR_SOURCE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5328))
#define BX_REG_TRIG_SOURCE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x532C))
#define BX_REG_INT_SOURCE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5330))
#define BX_REG_DMEM_DATA_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5600))
#define BX_REG_DMEM_MIN_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5604))
#define BX_REG_DMEM_MAX_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5606))
#define BX_REG_DMEM_ADDR_CTR ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5608))
#define BX_REG_DEV_VEN_ID_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5400))
#define BX_REG_PCIX_CMD_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5440))
#define BX_REG_PCIX_STAT_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5444))
#define BX_REG_DEV_VEN_ID_MASK_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5480))
#define BX_REG_PCIX_CMD_MASK_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x54C0))
#define BX_REG_PCIX_STAT_MASK_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x54C4))
#define BX_REG_CNF_HELP_BIT_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5500))
#define BX_REG_CNF_ADD_HELP_BIT_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5504))
#define BX_REG_CNF_DO_RETRY_BIT_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5506))
#define BX_REG_CNF_DO_RETRY_SYNC_BIT_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5508))
#define BX_REG_CNF_INTR_MASK_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5510))
#define BX_REG_CNF_INTR_STATUS_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5514))
#define BX_REG_CPU_HELP_BUS_ADDR_LO_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5540))
#define BX_REG_CPU_HELP_BUS_ADDR_UP_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5544))
#define BX_REG_CPU_HELP_BUS_INFO_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5548))
#define BX_REG_CPU_HELP_COMP_INFO_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x554A))
#define BX_REG_CPU_HELP_COMP_ADDR_LO_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x554C))
#define BX_REG_CPU_HELP_COMP_ADDR_UP_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5550))
#define BX_REG_CPU_HELP_DATA_DOWN_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5554))
#define BX_REG_CPU_HELP_DATA_UP_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5558))
#define BX_REG_RESERVED_DATA_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x555C))
#define BX_REG_CPU_HELP_CTRL_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5560))
#define BX_REG_PROGR_DATA_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5580))
#define BX_REG_PROGR_STATUS_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5584))
#define BX_REG_MBOX_STATUS_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5586))
#define BX_REG_MBOX_DATA_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5588))
#define BX_REG_PROGR_INTR_STATUS_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x558C))
#define BX_REG_PROGR_INTR_MASK_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x558E))
#define BX_REG_PROGR_ACCESS_MODE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x558E))
#define BX_REG_FIFO_AF_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5C00))
#define BX_REG_FIFO_AE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5C04))
#define BX_REG_FIFO_STATUS_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5C08))
#define BX_REG_ERR_CMPDATA_LOW_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5C40))
#define BX_REG_ERR_CMPDATA_LOW_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5700))
#define BX_REG_ERR_CMPDATA_HIGH_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5C44))
#define BX_REG_ERR_CMPDATA_HIGH_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5704))
#define BX_REG_ERR_BUSDATA_LOW_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5C48))
#define BX_REG_ERR_BUSDATA_LOW_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5708))
#define BX_REG_ERR_BUSDATA_HIGH_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5C4C))
#define BX_REG_ERR_BUSDATA_HIGH_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x570c))
#define BX_REG_ERR_BUSADDR_LOW_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5C50))
#define BX_REG_ERR_BUSADDR_LOW_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5710))
#define BX_REG_ERR_BUSADDR_HIGH_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5C54))
#define BX_REG_ERR_BUSADDR_HIGH_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5714))
#define BX_REG_ERR_BUSATTR_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5C58))
#define BX_REG_ERR_BUSATTR_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5718))
#define BX_REG_ERR_DPH_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5C60))
#define BX_REG_ERR_DPH_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5720))
#define BX_REG_ERR_CMDBE_M ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5C64))
#define BX_REG_ERR_CMDBE_F ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5724))
#define BX_REG_ERR_STATUS_M ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5C68))
#define BX_REG_ERR_STATUS_F ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5728))
#define BX_REG_ERR_CLEAR_STRB ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5C70))
#define BX_REG_ERR_CLEAR_STRB_F ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5730))
#define BX_REG_STAT_PAR_ERR_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5C78))
#define BX_REG_TRIG0_SLCT_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5C80))
#define BX_REG_TRIG1_SLCT_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5C84))
#define BX_REG_TRIG2_SLCT_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5C88))
#define BX_REG_TRIG3_SLCT_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5C8C))
#define BX_REG_TRIG0_MODE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5C90))
#define BX_REG_TRIG1_MODE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5C94))
#define BX_REG_TRIG2_MODE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5C98))
#define BX_REG_TRIG3_MODE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5C9C))
#define BX_REG_STAT_IAE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5CA0))
#define BX_REG_TDGEN_PATRNSEL_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5CC0))
#define BX_REG_TDGEN_ID_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5CD0))
#define BX_REG_TDGEN_OFFSET_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5CD4))
#define BX_REG_MDGEN_PATRNSEL_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5640))
#define BX_REG_MDGEN_ID_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5650))
#define BX_REG_MDGEN_OFFSET_REG ((ULONGADDR) (BX_MEPHISTO_OFFSET + 0x5654))
#define BX_REG_CSPLIT_MESSAGE_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5D00))
#define BX_REG_ERR_CTRL_REG ((UWORDADDR) (BX_MEPHISTO_OFFSET + 0x5C6C))
/***********************************************************************
*** End of generated code
************************************************************************/
